/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWLockWork;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class VWLockWorkDialog
extends VWModalDialog {
    static final int COL_LOCK_STATUS = 0;
    static final int COL_STEP = 1;
    static final int COL_PARTICIPANT = 2;
    static final int COL_LOCKED_BY = 3;
    private boolean m_bCanceled = true;
    private Vector m_participants = null;
    private JLabel m_success = null;
    private JLabel m_failed = null;
    private VWTable m_table = null;
    private JLabel m_lockCmd = null;
    private JLabel m_cancelCmd = null;
    private VWLockWorkTableModel m_tableModel = null;
    private VWLockWork m_lockWork = null;
    private JButton m_okButton = null;
    private ActionListener m_okButtonActionListener = null;
    private JButton m_cancelButton = null;
    private ActionListener m_cancelButtonActionListener = null;
    private JButton m_helpButton = null;
    private ActionListener m_helpButtonActionListener = null;

    public VWLockWorkDialog(Frame parent, VWLockWork lockWork) throws Exception {
        super(parent);
        this.m_lockWork = lockWork;
        this.setupLayout();
    }

    public VWLockWorkDialog(Frame parent, VWTrkDataModel dataModel) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, dataModel);
        this.setupLayout();
    }

    public VWLockWorkDialog(Frame parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, dataModel, steps);
        this.setupLayout();
    }

    public VWLockWorkDialog(Frame parent, VWTrkStepOccurrence occurrence) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, occurrence);
        this.setupLayout();
    }

    public VWLockWorkDialog(Frame parent, VWTrkParticipant participant) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, participant);
        this.setupLayout();
    }

    public VWLockWorkDialog(Dialog parent, VWLockWork lockWork) throws Exception {
        super(parent);
        this.m_lockWork = lockWork;
        this.setupLayout();
    }

    public VWLockWorkDialog(Dialog parent, VWTrkDataModel dataModel) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, dataModel);
        this.setupLayout();
    }

    public VWLockWorkDialog(Dialog parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, dataModel, steps);
        this.setupLayout();
    }

    public VWLockWorkDialog(Dialog parent, VWTrkStepOccurrence occurrence) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, occurrence);
        this.setupLayout();
    }

    public VWLockWorkDialog(Dialog parent, VWTrkParticipant participant) throws Exception {
        super(parent);
        this.m_lockWork = new VWLockWork(parent, participant);
        this.setupLayout();
    }

    private void setupLayout() throws Exception {
        this.m_participants = this.m_lockWork.getParticipants();
        if (this.m_participants.size() <= 0 || this.m_lockWork.isSuccess()) {
            throw new Exception();
        }
        this.m_tableModel = new VWLockWorkTableModel(this.m_participants);
        try {
            JPanel northPanel = new JPanel();
            JPanel centerPanel = new JPanel();
            JPanel buttonPanel = new JPanel();
            JPanel commandPanel = new JPanel();
            Container container = this.getContentPane();
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_lockWorkDialogDim);
            if (dim == null) {
                dim = new Dimension(450, 300);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setTitle(VWResource.s_lockWorkDialogTitle);
            this.m_success = new JLabel(VWResource.s_successfullyLocked, VWImageLoader.createImageIcon("lockedByUser.gif"), 2);
            this.m_failed = new JLabel(VWResource.s_failedDuePriorLock, VWImageLoader.createImageIcon("lockedByOther.gif"), 2);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setEnabled(false);
            this.m_table.setShowGrid(false);
            TableColumn tc = this.m_table.getColumnModel().getColumn(0);
            tc.setMaxWidth(20);
            tc.setMinWidth(20);
            JScrollPane scrollPane = new JScrollPane(this.m_table);
            this.m_lockCmd = new JLabel(VWResource.s_lockWorkOK.toString(VWResource.s_ok));
            this.m_cancelCmd = new JLabel(VWResource.s_lockWorkCancel.toString(VWResource.s_cancel));
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_helpButton = new JButton(VWResource.s_help);
            northPanel.setLayout(new BoxLayout(northPanel, 3));
            northPanel.add(this.m_success);
            northPanel.add(this.m_failed);
            centerPanel.setLayout(new BoxLayout(centerPanel, 3));
            centerPanel.add(scrollPane);
            centerPanel.add(Box.createVerticalStrut(10));
            commandPanel.setLayout(new BoxLayout(commandPanel, 3));
            commandPanel.add(this.m_lockCmd);
            commandPanel.add(this.m_cancelCmd);
            commandPanel.add(Box.createVerticalStrut(10));
            buttonPanel.setLayout(new FlowLayout(2));
            buttonPanel.add(this.m_okButton);
            buttonPanel.add(this.m_cancelButton);
            buttonPanel.add(this.m_helpButton);
            buttonPanel.add(Box.createHorizontalStrut(20));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)northPanel, "First");
            mainPanel.add((Component)centerPanel, "Center");
            mainPanel.add((Component)commandPanel, "Last");
            container.setLayout(new BorderLayout());
            container.add((Component)mainPanel, "Center");
            container.add((Component)buttonPanel, "Last");
            container.add(Box.createVerticalStrut(20), "First");
            container.add(Box.createHorizontalStrut(20), "Before");
            container.add(Box.createHorizontalStrut(20), "After");
            this.m_okButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWLockWorkDialog.this.m_bCanceled = false;
                    VWLockWorkDialog.this.setVisible(false);
                }
            };
            this.m_okButton.addActionListener(this.m_okButtonActionListener);
            this.m_cancelButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWLockWorkDialog.this.m_bCanceled = true;
                    VWLockWorkDialog.this.setVisible(false);
                    VWLockWorkDialog.this.m_lockWork.unlock();
                }
            };
            this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
            this.m_helpButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt038.htm");
                }
            };
            this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_lockCmd.setFont(boldFont);
            this.m_cancelCmd.setFont(boldFont);
        }
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_participants = null;
        this.m_success = null;
        this.m_failed = null;
        if (this.m_table != null) {
            this.m_table.removeReferences();
            this.m_table = null;
        }
        this.m_lockCmd = null;
        this.m_cancelCmd = null;
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        if (this.m_lockWork != null) {
            this.m_lockWork.removeReferences();
            this.m_lockWork = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this.m_okButtonActionListener);
            this.m_okButtonActionListener = null;
            this.m_okButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButtonActionListener = null;
            this.m_helpButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButtonActionListener = null;
            this.m_cancelButton = null;
        }
        this.removeAll();
    }

    private class VWLockWorkTableModel
    extends AbstractTableModel {
        Vector m_data = null;
        String[] m_columnNames = new String[]{"", VWResource.s_step, VWResource.s_participant, VWResource.s_lockedBy};

        VWLockWorkTableModel(Vector data) {
            this.m_data = data;
        }

        public int getRowCount() {
            if (this.m_data != null) {
                return this.m_data.size();
            }
            return 0;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return ImageIcon.class;
                }
                case 1: 
                case 2: 
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.getRowCount()) {
                return null;
            }
            VWTrkParticipant participant = null;
            Object obj = this.m_data.elementAt(row);
            if (obj == null || !(obj instanceof VWTrkParticipant)) {
                return null;
            }
            participant = (VWTrkParticipant)obj;
            switch (col) {
                case 0: {
                    return participant.getLockedStatusIcon();
                }
                case 1: {
                    return participant.getStep().getStepName();
                }
                case 2: {
                    VWParticipantItem parItem = new VWParticipantItem(participant.getParticipant());
                    return parItem.getDisplayName();
                }
                case 3: {
                    return participant.getLockedUser();
                }
            }
            return null;
        }

        public void removeReferences() {
            this.m_data = null;
            for (int i = 0; i < this.m_columnNames.length; ++i) {
                this.m_columnNames[i] = null;
            }
            this.m_columnNames = null;
        }
    }
}

